<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ApplicationRole
 *
 * @ORM\Table(name="application_roles", uniqueConstraints={@ORM\UniqueConstraint(name="role_idx", columns={"app_id", "symbol"})})
 * @ORM\Entity
 */
class ApplicationRole
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="app_id", type="integer")
     */
    private $appId;

    /**
     * @var string
     *
     * @ORM\Column(name="symbol", type="string", length=100)
     */
    private $symbol;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="string", length=255)
     */
    private $description;


    /**
     * @ORM\ManyToOne(targetEntity="Application", inversedBy="roles", cascade={"persist"})
     * @ORM\JoinColumn(name="app_id", referencedColumnName="id")
     */
    protected $application;



    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="appRoles")
     * @ORM\JoinTable(name="user_application_roles",
     *      joinColumns={@ORM\JoinColumn(name="role_id", referencedColumnName="id")},
     *      inverseJoinColumns={@ORM\JoinColumn(name="user_id", referencedColumnName="id")}
     *      )
     */
    protected $users;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set appId
     *
     * @param integer $appId
     * @return ApplicationRole
     */
    public function setAppId($appId)
    {
        $this->appId = $appId;
    
        return $this;
    }

    /**
     * Get appId
     *
     * @return integer 
     */
    public function getAppId()
    {
        return $this->appId;
    }

    /**
     * Set symbol
     *
     * @param string $symbol
     * @return ApplicationRole
     */
    public function setSymbol($symbol)
    {
        $this->symbol = $symbol;
    
        return $this;
    }

    /**
     * Get symbol
     *
     * @return string 
     */
    public function getSymbol()
    {
        return $this->symbol;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return ApplicationRole
     */
    public function setDescription($description)
    {
        $this->description = $description;
    
        return $this;
    }

    /**
     * Get description
     *
     * @return string 
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->users = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Set application
     *
     * @param \VM\ApiBundle\Entity\Application $application
     * @return ApplicationRole
     */
    public function setApplication(\VM\ApiBundle\Entity\Application $application = null)
    {
        $this->application = $application;
    
        return $this;
    }

    /**
     * Get application
     *
     * @return \VM\ApiBundle\Entity\Application 
     */
    public function getApplication()
    {
        return $this->application;
    }

    /**
     * Add users
     *
     * @param \VM\ApiBundle\Entity\User $users
     * @return ApplicationRole
     */
    public function addUser(\VM\ApiBundle\Entity\User $users)
    {
        $this->users[] = $users;
    
        return $this;
    }

    /**
     * Remove users
     *
     * @param \VM\ApiBundle\Entity\User $users
     */
    public function removeUser(\VM\ApiBundle\Entity\User $users)
    {
        $this->users->removeElement($users);
    }

    /**
     * Get users
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getUsers()
    {
        return $this->users;
    }
}